package com.ElyStudio.leGaou.activities;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.adapter.AvatarAdapter;
import com.ElyStudio.leGaou.databinding.ActivityUpdateAvatarBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.Avatars;
import com.ElyStudio.leGaou.models.QuizzeAvatars;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.OnItemClick;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;

import java.util.List;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class UpdateAvatarActivity extends AppCompat implements OnItemClick {

    ActivityUpdateAvatarBinding binding;
    String selectedAvatar;
    BottomSheetDialog noInternetBottomSheet,errorOccurredBottomSheet;

    public static final String TAG = "UPDATE_AVATAR_ACTIVITY";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityUpdateAvatarBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.updateAvtarBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(selectedAvatar.trim().isEmpty())
                {
                    QuizzeSnackBar.showSnackBar(UpdateAvatarActivity.this,binding.getRoot(),getResources().getString(R.string.select_avatar_warning),getResources().getColor(R.color.error));
                }
                else
                {
                    updateAvatars();
                }
            }
        });


    }

    @Override
    protected void onStart() {
        super.onStart();
        getAvatars();
    }

    private void getAvatars(){

        if(CheckInternetConnection.isInternetConnected(UpdateAvatarActivity.this))
        {
            Call<QuizzeAvatars> getAvatarsCall = ApiController.getInstance().getApi().getAvatars();

            getAvatarsCall.enqueue(new Callback<QuizzeAvatars>() {
                @Override
                public void onResponse(Call<QuizzeAvatars> call, Response<QuizzeAvatars> response) {
                    if(response.body().getstatusCode() == 0)
                    {
                        if(response.body().avatarsList != null)
                        {
                            setAvatarRecyclerView(response.body().avatarsList);
                        }
                    }
                    else
                    {
                        showErrorOccurredBottomSheet();
                    }
                }

                @Override
                public void onFailure(Call<QuizzeAvatars> call, Throwable t) {
                    Log.d(TAG,"getAvatarsCall Failure = "+t.getLocalizedMessage());
                    showErrorOccurredBottomSheet();
                }
            });
        }
        else
        {
            showNoInternetBottomSheet();
        }
    }

    @Override
    public void onClick(String value) {
        selectedAvatar = value;
    }

    private void setAvatarRecyclerView(List<Avatars> avatarsList){
        binding.updateAvatarsRecyclerview.setLayoutManager(new GridLayoutManager(UpdateAvatarActivity.this,2, LinearLayoutManager.VERTICAL,false));
        binding.updateAvatarsRecyclerview.setAdapter(new AvatarAdapter(avatarsList, this));
    }

    private void updateAvatars(){

        Call<ApiResponse> updateAvatarCall = ApiController.getInstance().getApi().updateAvatar(FirebaseAuth.getInstance().getUid(), selectedAvatar);

        updateAvatarCall.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if(response.body().getStatusCode() == 0)
                {
                    QuizzeSnackBar.showSnackBar(UpdateAvatarActivity.this,binding.getRoot(),getResources().getString(R.string.avatar_updated),getResources().getColor(R.color.success));
                    startActivity(new Intent(UpdateAvatarActivity.this,UserProfileScreen.class));
                    finish();
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(UpdateAvatarActivity.this,binding.getRoot(),getResources().getString(R.string.internal_error),getResources().getColor(R.color.error));
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable t) {
                    Log.d(TAG,"updateAvatarCall Failure = "+t.getLocalizedMessage());
                    QuizzeSnackBar.showSnackBar(UpdateAvatarActivity.this,binding.getRoot(),getResources().getString(R.string.some_error_occurred),getResources().getColor(R.color.error));
            }
        });


    }

    public void showNoInternetBottomSheet(){

        noInternetBottomSheet = new BottomSheetDialog(UpdateAvatarActivity.this);
        View view = LayoutInflater.from(UpdateAvatarActivity.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        noInternetBottomSheet.setContentView(view);

        Button contactSupportBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = noInternetBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = noInternetBottomSheet.findViewById(R.id.bottomSheetTitle);
        noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = noInternetBottomSheet.findViewById(R.id.bottomSheetSubText);
        contactSupportBtn.setVisibility(View.GONE);

        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(CheckInternetConnection.isInternetConnected(UpdateAvatarActivity.this))
                {
                    noInternetBottomSheet.cancel();
                    getAvatars();
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(UpdateAvatarActivity.this,view,getResources().getString(R.string.no_internet),getResources().getColor(R.color.error));
                }
            }
        });

        bottomSheetTitle.setText(getResources().getString(R.string.no_internet));
        bottomSheetSubText.setText(getResources().getString(R.string.no_internet_sub_text));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(UpdateAvatarActivity.this,R.drawable.no_conection_illustration));

        if(!UpdateAvatarActivity.this.isFinishing())
        {
            noInternetBottomSheet.show();
        }

    }

    public void showErrorOccurredBottomSheet(){

        errorOccurredBottomSheet = new BottomSheetDialog(UpdateAvatarActivity.this);
        View view = LayoutInflater.from(UpdateAvatarActivity.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        errorOccurredBottomSheet.setContentView(view);
        errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = errorOccurredBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = errorOccurredBottomSheet.findViewById(R.id.bottomSheetTitle);
        TextView bottomSheetSubText = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSubText);

        bottomSheetTitle.setText(getResources().getString(R.string.some_error_occurred));
        bottomSheetSubText.setText(getResources().getString(R.string.error_subtext));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(UpdateAvatarActivity.this,R.drawable.error_illustration));
        contactSupportBtn.setText(getResources().getString(R.string.contact_support));
        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        contactSupportBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(UpdateAvatarActivity.this, SupportScreen.class));
            }
        });

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                errorOccurredBottomSheet.cancel();
                getAvatars();
            }
        });

        if(!UpdateAvatarActivity.this.isFinishing())
        {
            errorOccurredBottomSheet.show();
        }
    }
}